USE [ProSolutionReports]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [vOG_2526_Student]
AS

------------------------------------------------
--Student Import Template for OneGrade VA
------------------------------------------------
SELECT
	T.AcademicYearID,
	T.LearnerRef, 
	LEFT(SDet.Surname,40) AS Surname, 
	LEFT(COALESCE (SDet.FirstForename, '') + ' ' + COALESCE (SDet.OtherForenames, ''),70) AS Forenames, 
	SDet.DateOfBirth AS DOB, 
	SDet.EthnicGroupID, 
	'' AS LearningDifficultyID, -- edit as necessary for appropriate field in PS
	SDet.Sex AS SexID, 
	CASE WHEN SDet.WideningParticipationID IS NULL THEN 0 ELSE 1 END AS FSM, -- edit as necessary for appropriate field in PS
	TG.Code AS TutorGroupCode,
	NULL AS UDFS1, NULL AS UDFS2, NULL AS UDFS3, NULL AS UDFS4, NULL AS UDFNum, NULL AS UDFDate,
	NULL AS UDFS5, NULL AS UDFS6, NULL AS UDFS7, NULL AS UDFS8, NULL AS UDFNum2
	,CASE WHEN SDet.LearningDiffOrDisID = 1 THEN 'Y' ELSE 'N' END AS LearningDifforDis,
	SDet.Overseas,
	CASE WHEN ISNULL(SDet.PlannedLearningHours,0) >=150 THEN 'N' ELSE 'Y' END AS Under150Hrs

FROM 
	(
		--This will return the key enrolment records and avoid duplicates
		SELECT DISTINCT
			Min(SD.StudentDetailID) AS MinStudentDetailID,
			SD.AcademicYearID,								--*UniqueKey
			SD.RefNo AS LearnerRef							--*UniqueKey
	
		FROM         
			ProSolution.dbo.StudentDetail AS SD WITH (NOLOCK) 
			--Refer back to the vOG_2526_Enrolment View to only find students for Enrolments being Imported
			INNER JOIN vOG_2526_Enrolment WITH (NOLOCK)
				ON vOG_2526_Enrolment.AcademicYearID = SD.AcademicYearID
				AND vOG_2526_Enrolment.LearnerRef = SD.RefNo
		WHERE     
			SD.AcademicYearID = '25/26' 
		GROUP BY
			SD.AcademicYearID, SD.RefNo
	) T

--ensure that we join on T.MinStudentDetailID
INNER JOIN        
	ProSolution.dbo.StudentDetail AS SDet WITH (NOLOCK) 
	ON T.MinStudentDetailID = SDet.StudentDetailID
	LEFT JOIN ProSolution.dbo.Staff AS S WITH (NOLOCK) 
		ON S.StaffID = SDet.TutorID 	
		LEFT JOIN ProSolution.dbo.TutorGroup TG WITH (NOLOCK) 
			ON SDet.TutorGroupID = TG.TutorGroupID	




GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO